<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'PT MENARA PONDASI UTAMA')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans antialiased bg-gradient-to-br from-blue-50 to-blue-100 min-h-screen">
        <div class="min-h-screen flex flex-col">
            <header class="bg-white/90 shadow flex items-center px-4 py-2 border-b border-blue-100">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 flex items-center justify-center bg-blue-100 rounded-full border-2 border-blue-200">
                        <span class="text-lg font-bold text-blue-700">MPU</span>
                    </div>
                    <span class="font-extrabold text-blue-800 text-lg tracking-wide hidden sm:block">PT MENARA PONDASI UTAMA</span>
                </div>
                <div class="flex-1"></div>
                <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </header>

            <!-- Page Heading -->
            <?php if(isset($header)): ?>
                <div class="bg-white/80 shadow rounded-b-lg mx-auto mt-4 max-w-4xl w-full px-6 py-4">
                    <?php echo e($header); ?>

                </div>
            <?php endif; ?>

            <!-- Page Content -->
            <main class="flex-1 flex justify-center items-start py-8">
                <div class="w-full max-w-4xl">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </main>
        </div>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\AbsensiKaryawan\resources\views/layouts/app.blade.php ENDPATH**/ ?>