<?php $__env->startSection('content'); ?>
    <h2 class="font-semibold text-xl text-gray-800 leading-tight mb-4">Absensi</h2>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-6">Absensi Hari Ini</h3>
                    
                    <?php if($absensiHariIni): ?>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                            <div class="text-center p-6 bg-gray-50 rounded-lg">
                                <div class="text-3xl font-bold text-gray-900 mb-2">
                                    <?php echo e($absensiHariIni->jam_masuk ? \Carbon\Carbon::parse($absensiHariIni->jam_masuk)->format('H:i') : 'Belum Absen'); ?>

                                </div>
                                <div class="text-sm text-gray-500">Jam Masuk</div>
                                <?php if($absensiHariIni->foto_masuk): ?>
                                    <img src="<?php echo e(asset('storage/'.$absensiHariIni->foto_masuk)); ?>" alt="Foto Masuk" class="mx-auto mt-2 rounded shadow h-24">
                                <?php endif; ?>
                            </div>
                            
                            <div class="text-center p-6 bg-gray-50 rounded-lg">
                                <div class="text-3xl font-bold text-gray-900 mb-2">
                                    <?php echo e($absensiHariIni->jam_pulang ? \Carbon\Carbon::parse($absensiHariIni->jam_pulang)->format('H:i') : 'Belum Pulang'); ?>

                                </div>
                                <div class="text-sm text-gray-500">Jam Pulang</div>
                                <?php if($absensiHariIni->foto_pulang): ?>
                                    <img src="<?php echo e(asset('storage/'.$absensiHariIni->foto_pulang)); ?>" alt="Foto Pulang" class="mx-auto mt-2 rounded shadow h-24">
                                <?php endif; ?>
                            </div>
                            
                            <div class="text-center p-6 bg-gray-50 rounded-lg">
                                <div class="text-3xl font-bold text-gray-900 mb-2">
                                    <?php echo e($absensiHariIni->total_jam ? $absensiHariIni->getTotalJamFormatted() : '-'); ?>

                                </div>
                                <div class="text-sm text-gray-500">Total Jam Kerja</div>
                            </div>
                        </div>
                        
                        <?php if($absensiHariIni->jam_lembur > 0): ?>
                            <div class="text-center p-4 bg-orange-50 rounded-lg mb-6">
                                <div class="text-lg font-semibold text-orange-800">
                                    Lembur: <?php echo e($absensiHariIni->getJamLemburFormatted()); ?>

                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Action Buttons -->
                        <div class="flex flex-col sm:flex-row gap-4">
                            <?php if(!$absensiHariIni->jam_masuk): ?>
                                <form action="<?php echo e(route('absensi.masuk')); ?>" method="POST" enctype="multipart/form-data" class="flex-1">
                                    <?php echo csrf_field(); ?>
                                    <input type="file" name="foto_masuk" accept="image/*" required class="mb-2">
                                    <button type="submit" class="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-3 px-4 rounded-lg transition duration-150 ease-in-out">
                                        <div class="text-xl">Absen Masuk</div>
                                        <div class="text-sm opacity-90"><?php echo e(\Carbon\Carbon::now()->format('H:i:s')); ?></div>
                                    </button>
                                </form>
                            <?php elseif(!$absensiHariIni->jam_pulang): ?>
                                <form action="<?php echo e(route('absensi.pulang')); ?>" method="POST" enctype="multipart/form-data" class="flex-1">
                                    <?php echo csrf_field(); ?>
                                    <input type="file" name="foto_pulang" accept="image/*" required class="mb-2">
                                    <button type="submit" class="w-full bg-red-600 hover:bg-red-700 text-white font-bold py-3 px-4 rounded-lg transition duration-150 ease-in-out">
                                        <div class="text-xl">Absen Pulang</div>
                                        <div class="text-sm opacity-90"><?php echo e(\Carbon\Carbon::now()->format('H:i:s')); ?></div>
                                    </button>
                                </form>
                            <?php else: ?>
                                <div class="w-full text-center p-4 bg-green-50 rounded-lg">
                                    <div class="text-lg font-semibold text-green-800">
                                        Absensi hari ini sudah lengkap!
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-12">
                            <div class="text-gray-500 mb-6">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <div class="mt-4 text-lg">Belum ada absensi hari ini</div>
                            </div>
                            
                            <form action="<?php echo e(route('absensi.masuk')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="file" name="foto_masuk" accept="image/*" required class="mb-2">
                                <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-3 px-6 rounded-lg transition duration-150 ease-in-out">
                                    <div class="text-xl">Mulai Absen Masuk</div>
                                    <div class="text-sm opacity-90"><?php echo e(\Carbon\Carbon::now()->format('H:i:s')); ?></div>
                                </button>
                            </form>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Quick Actions -->
            <!-- Bagian pengajuan izin & sakit dihapus -->

                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6">
                        <h4 class="text-lg font-medium text-gray-900 mb-4">Informasi</h4>
                        <div class="space-y-4 text-sm text-gray-600">
                            <div class="flex items-start">
                                <div class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></div>
                                <div>Jam kerja normal: 8 jam per hari</div>
                            </div>
                            <div class="flex items-start">
                                <div class="w-2 h-2 bg-orange-500 rounded-full mt-2 mr-3 flex-shrink-0"></div>
                                <div>Lembur dihitung otomatis jika > 8 jam</div>
                            </div>
                            <div class="flex items-start">
                                <div class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></div>
                                <div>Absen masuk dan pulang wajib dilakukan</div>
                            </div>
                            <div class="flex items-start">
                                <div class="w-2 h-2 bg-yellow-500 rounded-full mt-2 mr-3 flex-shrink-0"></div>
                                <div>Izin dan sakit harus diajukan terlebih dahulu</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\AbsensiKaryawan\resources\views/karyawan/absensi.blade.php ENDPATH**/ ?>