<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AbsensiController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\LaporanController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\KaryawanController;

Route::get('/', function () {
    return view('welcome');
});

// Dashboard karyawan tetap
Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified', 'checkrole:karyawan_tetap'])
    ->name('dashboard');

// Dashboard admin
Route::get('/admin', [DashboardController::class, 'adminDashboard'])
    ->middleware(['auth', 'verified', 'checkrole:admin'])
    ->name('admin.dashboard');

// Karyawan Tetap routes (self-attendance)
Route::middleware(['auth', 'checkrole:karyawan_tetap'])->group(function () {
    Route::get('/absensi', [AbsensiController::class, 'index'])->name('absensi.index');
    Route::post('/absensi/masuk', [AbsensiController::class, 'masuk'])->name('absensi.masuk');
    Route::post('/absensi/pulang', [AbsensiController::class, 'pulang'])->name('absensi.pulang');
});

// Admin routes
Route::middleware(['auth', 'checkrole:admin'])->prefix('admin')->name('admin.')->group(function () {
    // Karyawan Lepas management
    Route::get('/karyawan-lepas', [AdminController::class, 'karyawanLepas'])->name('karyawan-lepas');
    Route::post('/karyawan-lepas/absen', [AdminController::class, 'absenKaryawanLepas'])->name('karyawan-lepas.absen');
    Route::get('/absensi/{id}/edit', [AdminController::class, 'editAbsensi'])->name('absensi.edit');
    Route::put('/absensi/{id}', [AdminController::class, 'updateAbsensi'])->name('absensi.update');
    Route::delete('/absensi/{id}', [AdminController::class, 'deleteAbsensi'])->name('absensi.delete');
    
    // User management
    Route::get('/users', [AdminController::class, 'manageUsers'])->name('manage-users');
    Route::get('/users/create', [AdminController::class, 'createUser'])->name('users.create');
    Route::post('/users', [AdminController::class, 'storeUser'])->name('users.store');
    Route::get('/users/{id}/edit', [AdminController::class, 'editUser'])->name('users.edit');
    Route::put('/users/{id}', [AdminController::class, 'updateUser'])->name('users.update');
    
    // Reports
    Route::get('/laporan', [LaporanController::class, 'index'])->name('laporan');
    Route::get('/laporan/export-excel', [LaporanController::class, 'exportExcel'])->name('laporan.exportExcel');
    Route::get('/laporan/export-pdf', [LaporanController::class, 'exportPdf'])->name('laporan.exportPdf');
    Route::post('/laporan/absensi', [LaporanController::class, 'absensi'])->name('laporan.absensi');
    Route::post('/laporan/lembur', [LaporanController::class, 'lembur'])->name('laporan.lembur');
    // Daftar & hapus absensi hari ini
    Route::get('/absensi-hari-ini', [AdminController::class, 'absensiHariIni'])->name('absensi-hari-ini');
    Route::delete('/absensi-hari-ini/{id}', [AdminController::class, 'hapusAbsensi'])->name('absensi-hari-ini.hapus');
    // Input absensi karyawan lepas
    Route::post('/absensi-lepas/input', [AdminController::class, 'inputAbsensiLepas'])->name('absensi-lepas.input');
    
    // Export routes - pindahkan ke dalam grup admin dan perbaiki nama rute
    Route::get('/absensi/export-pdf', [AdminController::class, 'exportPDF'])->name('absensi.export-pdf');
    Route::get('/absensi/export-excel', [AdminController::class, 'exportExcel'])->name('absensi.export-excel');
    // Absensi Mingguan
    Route::get('/absensi-mingguan', [AdminController::class, 'absensiMingguan'])->name('absensi-mingguan');
    Route::get('/absensi-mingguan/export-pdf', [AdminController::class, 'exportPDFMingguan'])->name('absensi-mingguan.export-pdf');
    Route::get('/absensi-mingguan/export-excel', [AdminController::class, 'exportExcelMingguan'])->name('absensi-mingguan.export-excel');
});

require __DIR__.'/auth.php';

Route::middleware(['auth'])->group(function () {
    Route::get('/karyawan/isi-data', [KaryawanController::class, 'formPengisianData'])->name('karyawan.isi-data');
    Route::post('/karyawan/isi-data', [KaryawanController::class, 'simpanPengisianData'])->name('karyawan.isi-data.simpan');
});

// Profile routes
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});
