@extends('layouts.app')

@section('content')
<div class="min-h-screen flex items-center justify-center bg-blue-50">
    <div class="bg-white shadow-lg rounded-lg p-8 w-full max-w-md">
        <h2 class="text-2xl font-bold text-blue-800 mb-6 text-center">Lengkapi Data Karyawan</h2>
        <form method="POST" action="{{ route('karyawan.isi-data.simpan') }}">
            @csrf
            <div class="mb-4">
                <label class="block text-gray-700 mb-1">Nama</label>
                <input type="text" class="w-full border rounded px-3 py-2 bg-gray-100" value="{{ $user->name }}" disabled>
            </div>
            <div class="mb-4">
                <label class="block text-gray-700 mb-1">Email</label>
                <input type="email" class="w-full border rounded px-3 py-2 bg-gray-100" value="{{ $user->email }}" disabled>
            </div>
            <div class="mb-4">
                <label for="nip" class="block text-gray-700 mb-1">NIP</label>
                <input type="text" name="nip" id="nip" class="w-full border rounded px-3 py-2" value="{{ old('nip', $user->nip) }}" required>
                @error('nip')<div class="text-red-500 text-xs mt-1">{{ $message }}</div>@enderror
            </div>
            <div class="mb-6">
                <label for="jabatan" class="block text-gray-700 mb-1">Jabatan</label>
                <input type="text" name="jabatan" id="jabatan" class="w-full border rounded px-3 py-2" value="{{ old('jabatan', $user->jabatan) }}" required>
                @error('jabatan')<div class="text-red-500 text-xs mt-1">{{ $message }}</div>@enderror
            </div>
            <div class="mb-6">
                <label for="lokasi" class="block text-gray-700 mb-1">Lokasi</label>
                <input type="text" name="lokasi" id="lokasi" class="w-full border rounded px-3 py-2" value="{{ old('lokasi', $user->lokasi) }}" required>
                @error('lokasi')<div class="text-red-500 text-xs mt-1">{{ $message }}</div>@enderror
            </div>
            <input type="hidden" name="role" value="karyawan_tetap">
            <button type="submit" class="w-full bg-blue-700 hover:bg-blue-800 text-white font-bold py-2 rounded-lg transition">Simpan Data</button>
        </form>
    </div>
</div>
@endsection 