<x-guest-layout>
    <div class="flex min-h-screen items-center justify-center bg-gradient-to-br from-blue-50 to-blue-100">
        <div class="bg-white shadow-2xl rounded-2xl p-8 w-full max-w-md">
            <h2 class="text-2xl font-extrabold text-blue-800 mb-6 text-center">Register Karyawan</h2>
            <form method="POST" action="{{ route('register') }}">
                @csrf
                <div class="mb-4">
                    <x-input-label for="name" :value="__('Name')" class="text-gray-700 mb-1" />
                    <x-text-input id="name" class="block w-full border rounded px-3 py-2 bg-gray-50" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" />
                    <x-input-error :messages="$errors->get('name')" class="mt-2" />
                </div>
                <div class="mb-4">
                    <x-input-label for="email" :value="__('Email')" class="text-gray-700 mb-1" />
                    <x-text-input id="email" class="block w-full border rounded px-3 py-2 bg-gray-50" type="email" name="email" :value="old('email')" required autocomplete="username" />
                    <x-input-error :messages="$errors->get('email')" class="mt-2" />
                </div>
                <div class="mb-4">
                    <x-input-label for="password" :value="__('Password')" class="text-gray-700 mb-1" />
                    <x-text-input id="password" class="block w-full border rounded px-3 py-2 bg-gray-50" type="password" name="password" required autocomplete="new-password" />
                    <x-input-error :messages="$errors->get('password')" class="mt-2" />
                </div>
                <div class="mb-4">
                    <x-input-label for="password_confirmation" :value="__('Confirm Password')" class="text-gray-700 mb-1" />
                    <x-text-input id="password_confirmation" class="block w-full border rounded px-3 py-2 bg-gray-50" type="password" name="password_confirmation" required autocomplete="new-password" />
                    <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                </div>
                <div class="flex items-center justify-end mb-2">
                    <a class="underline text-sm text-blue-700 hover:text-blue-900 rounded-md" href="{{ route('login') }}">
                        {{ __('Already registered?') }}
                    </a>
                </div>
                <button type="submit" class="w-full bg-blue-700 hover:bg-blue-800 text-white font-bold py-3 rounded-lg transition text-lg shadow">Register</button>
            </form>
        </div>
    </div>
</x-guest-layout>
