<x-guest-layout>
    <div class="flex min-h-screen items-center justify-center bg-gradient-to-br from-blue-50 to-blue-100">
        <div class="bg-white shadow-2xl rounded-2xl p-8 w-full max-w-md">
            <h2 class="text-2xl font-extrabold text-blue-800 mb-6 text-center">Login Karyawan</h2>
            <x-auth-session-status class="mb-4" :status="session('status')" />
            <form method="POST" action="{{ route('login') }}">
                @csrf
                <div class="mb-4">
                    <x-input-label for="email" :value="__('Email')" class="text-gray-700 mb-1" />
                    <x-text-input id="email" class="block w-full border rounded px-3 py-2 bg-gray-50" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" />
                    <x-input-error :messages="$errors->get('email')" class="mt-2" />
                </div>
                <div class="mb-4">
                    <x-input-label for="password" :value="__('Password')" class="text-gray-700 mb-1" />
                    <x-text-input id="password" class="block w-full border rounded px-3 py-2 bg-gray-50" type="password" name="password" required autocomplete="current-password" />
                    <x-input-error :messages="$errors->get('password')" class="mt-2" />
                </div>
                <div class="flex items-center justify-between mb-6">
                    <label for="remember_me" class="inline-flex items-center">
                        <input id="remember_me" type="checkbox" class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500" name="remember">
                        <span class="ms-2 text-sm text-gray-600">{{ __('Remember me') }}</span>
                    </label>
                    @if (Route::has('password.request'))
                        <a class="text-sm text-blue-700 hover:underline" href="{{ route('password.request') }}">
                            {{ __('Forgot your password?') }}
                        </a>
                    @endif
                </div>
                <button type="submit" class="w-full bg-blue-700 hover:bg-blue-800 text-white font-bold py-3 rounded-lg transition text-lg shadow mb-2">Log in</button>
            </form>
        </div>
    </div>
</x-guest-layout>
