<!DOCTYPE html>
<html>
<head>
    <title>Laporan Absensi</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid black;
            padding: 5px;
            text-align: left;
        }
        th {
            background-color: #f3f4f6;
        }
    </style>
</head>
<body>
    <h2>Laporan Absensi Tanggal {{ \Carbon\Carbon::parse($tanggal)->format('d-m-Y') }}</h2>
    
    <table>
        <thead>
            <tr>
                <th>Nama</th>
                <th>Admin</th>
                <th>Lokasi Input</th>
                <th>Jam Masuk</th>
                <th>Jam Pulang</th>
                <th>Lokasi</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($absensi as $item)
                <tr>
                    <td>{{ $item->user->name ?? $item->nama_karyawan }}</td>
                    <td>{{ $item->nama_admin ?? '-' }}</td>
                    <td>{{ $item->lokasi_input ?? '-' }}</td>
                    <td>{{ $item->jam_masuk ? \Carbon\Carbon::parse($item->jam_masuk)->format('H:i') : '-' }}</td>
                    <td>{{ $item->jam_pulang ? \Carbon\Carbon::parse($item->jam_pulang)->format('H:i') : '-' }}</td>
                    <td>{{ $item->lokasi ?? '-' }}</td>
                    <td>{{ ucfirst($item->status) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>