<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create permissions
        $permissions = [
            'view-dashboard',
            'manage-users',
            'view-attendance',
            'create-attendance',
            'edit-attendance',
            'delete-attendance',
            'view-overtime',
            'create-overtime',
            'edit-overtime',
            'approve-overtime',
            'export-reports',
            'view-reports',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create roles
        $adminRole = Role::create(['name' => 'admin']);
        $karyawanTetapRole = Role::create(['name' => 'karyawan_tetap']);
        $karyawanLepasRole = Role::create(['name' => 'karyawan_lepas']);

        // Assign permissions to admin
        $adminRole->givePermissionTo($permissions);

        // Assign permissions to karyawan tetap
        $karyawanTetapRole->givePermissionTo([
            'view-dashboard',
            'view-attendance',
            'create-attendance',
            'view-overtime',
            'view-reports',
        ]);

        // Assign permissions to karyawan lepas (read-only)
        $karyawanLepasRole->givePermissionTo([
            'view-dashboard',
            'view-attendance',
            'view-overtime',
            'view-reports',
        ]);
    }
}
