<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['admin', 'karyawan_tetap', 'karyawan_lepas'])->default('karyawan_tetap');
            $table->string('nip')->nullable(); // Nomor Induk Pegawai
            $table->string('jabatan')->nullable();
            $table->decimal('gaji_pokok', 12, 2)->default(0);
            $table->decimal('tarif_lembur', 10, 2)->default(0); // Tarif per jam lembur
            $table->boolean('is_active')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['role', 'nip', 'jabatan', 'gaji_pokok', 'tarif_lembur', 'is_active']);
        });
    }
};
