<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Absensi;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        if ($user->role === 'admin') {
            return redirect()->route('admin.dashboard');
        }

        return $this->karyawanTetapDashboard();
    }

    public function adminDashboard()
    {
        $today = Carbon::today();
        
        // Get statistics for admin dashboard
        $totalKaryawan = User::where('is_active', true)->count();
        $karyawanTetap = User::where('role', 'karyawan_tetap')->where('is_active', true)->count();
        $karyawanLepasCount = User::where('role', 'karyawan_lepas')->where('is_active', true)->count();
        
        $hadirHariIni = Absensi::where('tanggal', $today)
            ->where('status', 'hadir')
            ->count();
        
        $izinHariIni = Absensi::where('tanggal', $today)
            ->where('status', 'izin')
            ->count();
        
        $sakitHariIni = Absensi::where('tanggal', $today)
            ->where('status', 'sakit')
            ->count();
        
        $alphaHariIni = Absensi::where('tanggal', $today)
            ->where('status', 'alpha')
            ->count();

        // Get recent attendance records
        $recentAbsensi = Absensi::with('user')
            ->where('tanggal', $today)
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get();

        return view('admin.dashboard', compact(
            'totalKaryawan',
            'karyawanTetap', 
            'karyawanLepasCount',
            'hadirHariIni',
            'izinHariIni',
            'sakitHariIni',
            'alphaHariIni',
            'recentAbsensi'
        ));
    }

    private function karyawanTetapDashboard()
    {
        $user = Auth::user();
        $today = Carbon::today();
        
        // Get today's attendance
        $absensiHariIni = $user->getAbsensiHariIni();
        
        // Get attendance history for this month
        $absensiBulanIni = $user->absensi()
            ->whereMonth('tanggal', $today->month)
            ->whereYear('tanggal', $today->year)
            ->orderBy('tanggal', 'desc')
            ->get();
        
        // Calculate statistics
        $totalHadir = $absensiBulanIni->where('status', 'hadir')->count();
        $totalIzin = $absensiBulanIni->where('status', 'izin')->count();
        $totalSakit = $absensiBulanIni->where('status', 'sakit')->count();
        $totalJamLembur = $absensiBulanIni->sum('jam_lembur');

        return view('karyawan.dashboard', compact(
            'absensiHariIni',
            'absensiBulanIni',
            'totalHadir',
            'totalIzin', 
            'totalSakit',
            'totalJamLembur'
        ));
    }
}
