<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class AbsensiExport implements FromCollection, WithHeadings, WithMapping
{
    protected $absensi;

    public function __construct($absensi)
    {
        $this->absensi = $absensi;
    }

    public function collection()
    {
        return $this->absensi;
    }

    public function headings(): array
    {
        return [
            'Nama',
            'Admin',
            'Lokasi Input',
            'Jam Masuk',
            'Jam Pulang',
            'Lokasi',
            'Status',
        ];
    }

    public function map($item): array
    {
        return [
            $item->user->name ?? $item->nama_karyawan,
            $item->nama_admin ?? '-',
            $item->lokasi_input ?? '-',
            $item->jam_masuk ? \Carbon\Carbon::parse($item->jam_masuk)->format('H:i') : '-',
            $item->jam_pulang ? \Carbon\Carbon::parse($item->jam_pulang)->format('H:i') : '-',
            $item->lokasi ?? '-',
            ucfirst($item->status),
        ];
    }
}