


          
# Sistem Absensi Karyawan

Aplikasi web untuk mengelola absensi karyawan dengan fitur absensi harian dan mingguan, ekspor data, dan manajemen karyawan.

## Fitur

- Multi-role user (Admin, Karyawan Tetap, Karyawan Lepas)
- Absensi dengan foto dan lokasi
- Rekap absensi harian dan mingguan
- Ekspor data ke PDF dan Excel
- Manajemen data karyawan
- Perhitungan jam kerja dan lembur otomatis

## Teknologi

- Laravel 10
- PHP 8.3
- MySQL
- Tailwind CSS
- DomPDF
- Laravel Excel

## Persyaratan Sistem

- PHP >= 8.3
- Composer
- MySQL/MariaDB
- Node.js & NPM

## Instalasi

1. Clone repository
```bash
git clone https://github.com/username/absensi-karyawan.git
cd absensi-karyawan
```

2. Install dependensi PHP
```bash
composer install
```

3. Install dependensi Node.js
```bash
npm install
```

4. Salin file .env
```bash
cp .env.example .env
```

5. Generate key aplikasi
```bash
php artisan key:generate
```

6. Konfigurasi database di file .env
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=absensi_karyawan
DB_USERNAME=root
DB_PASSWORD=
```

7. Jalankan migrasi dan seeder
```bash
php artisan migrate --seed
```

8. Compile assets
```bash
npm run dev
```

9. Jalankan server
```bash
php artisan serve
```

## Penggunaan

### Login Admin
- Email: admin@example.com
- Password: password

### Fitur Admin
1. Dashboard
   - Statistik total karyawan
   - Statistik absensi hari ini
   - Quick actions

2. Manajemen Karyawan
   - Tambah/edit/hapus karyawan
   - Atur role dan status aktif
   - Input data pribadi dan gaji

3. Absensi
   - Lihat absensi harian
   - Rekap absensi mingguan
   - Input absensi karyawan lepas
   - Ekspor data ke PDF/Excel

### Fitur Karyawan
1. Absensi
   - Check-in dengan foto
   - Check-out dengan foto
   - Input lokasi otomatis

2. Riwayat Absensi
   - Lihat riwayat absensi pribadi
   - Detail jam kerja dan lembur

## Struktur Database

### Users
- id
- name
- email
- password
- role (admin/karyawan_tetap/karyawan_lepas)
- nip
- jabatan
- lokasi
- is_active
- gaji_pokok
- tarif_lembur

### Absensi
- id
- user_id
- nama_karyawan
- tanggal
- jam_masuk
- jam_pulang
- foto_masuk
- foto_pulang
- lokasi_input
- status
- total_jam
- jam_lembur
- keterangan
- tipe_input
- admin_id
- nama_admin

## Kontribusi

1. Fork repository
2. Buat branch fitur (`git checkout -b fitur-baru`)
3. Commit perubahan (`git commit -am 'Menambah fitur baru'`)
4. Push ke branch (`git push origin fitur-baru`)
5. Buat Pull Request

## Lisensi

MIT License - lihat file [LICENSE](LICENSE) untuk detail.

## Kontak

Jika Anda memiliki pertanyaan atau masukan, silakan buat issue di repository ini.
        
